//
//  FileRecorder.m
//  SpeechDemo
//
//  Created by fangweiwei on 2021/8/31.
//  Copyright © 2021 fangweiwei. All rights reserved.
//

#import "FileRecorder.h"
#import "FileUtils.h"

@interface FileRecorder ()

@property (nonatomic, weak) SpeechEngine *curEngine;
@property (nonatomic, strong) NSThread *worker;
@property (nonatomic, copy) NSString *path;
@property (nonatomic, copy) NSString *filename;

@end

@implementation FileRecorder

- (instancetype)init
{
    self = [super init];
    if (self) {
        _worker = nil;
    }
    return self;
}

- (void)setSpeechEngine:(SpeechEngine *)engine {
    self.curEngine = engine;
}

- (BOOL)startWithPath:(NSString *)path filename:(NSString *)filename {
    if (self.worker) {
        if (self.worker.executing) {
            NSLog(@"Already start!");
            return TRUE;
        }
        [self.worker cancel];
        self.worker = nil;
    }

    self.path = path;
    self.filename = filename;
    self.worker = [[NSThread alloc] initWithTarget:self selector:@selector(runner) object:nil];
    [self.worker start];
    return TRUE;
}

- (void)stop {
    if (!self.worker) {
        NSLog(@"Not start yet!");
        return;
    }

    [self.worker cancel];
    self.worker = nil;
}

- (void)runner {
    NSUInteger dataLength = 8000 * 2 * 0.1;
    NSFileHandle *file = [FileUtils openFileForReading:self.filename inPath:self.path];
    NSUInteger total = 0;
    while (!self.worker.cancelled) {
        NSData *data;
        if (![FileUtils readData:&data length:dataLength fromFileHandel:file]) {
            break;
        }
        total += data.length;
        if (data.length > 0) {
            SEErrorCode ret = [self.curEngine feedAudio:(int16_t *)data.bytes length:(int32_t)(data.length / 2)];
            if (ret) {
                NSLog(@"Feed audio data failed: %d, lenght: %lu.", ret, (unsigned long)(data.length / 2));
                break;
            }
        } else {
            NSLog(@"Finished reading");
            break;
        }
    }
    NSLog(@"Read tatal: %lu", (unsigned long)total);
    [FileUtils closeFile:file];
}

@end
