package com.example.aivoice_plugin

import android.app.Application
import android.content.Context
import androidx.annotation.NonNull
import com.bytedance.speech.speechengine.SpeechEngineGenerator
import io.flutter.embedding.engine.plugins.FlutterPlugin
import io.flutter.plugin.common.EventChannel
import io.flutter.plugin.common.EventChannel.EventSink
import io.flutter.plugin.common.MethodCall
import io.flutter.plugin.common.MethodChannel
import io.flutter.plugin.common.MethodChannel.MethodCallHandler
import io.flutter.plugin.common.MethodChannel.Result


/** AivoicePlugin */
class AivoicePlugin: FlutterPlugin, MethodCallHandler, EventChannel.StreamHandler {


  /// The MethodChannel that will the communication between Flutter and native Android
  ///
  /// This local reference serves to register the plugin with the Flutter Engine and unregister it
  /// when the Flutter Engine is detached from the Activity
  private lateinit var channel : MethodChannel
  private var context: Context? = null

  private  var asrConfig : Map<String, String>? = null

  private val eventChannel: EventChannel? = null
  private var events: EventSink? = null



  private val asrCenter: AsrCenter by lazy {
    AsrCenter(context, AsrCenter.AsrCenterCallback {
      sendMessageToFlutter(it)
    })
  }

  override fun onAttachedToEngine(@NonNull flutterPluginBinding: FlutterPlugin.FlutterPluginBinding) {
    context = flutterPluginBinding.applicationContext;
    channel = MethodChannel(flutterPluginBinding.binaryMessenger, "aivoice_plugin")
    channel.setMethodCallHandler(this)
    val eventChannel = EventChannel(flutterPluginBinding.binaryMessenger, "aivoice_plugin/events")
    eventChannel.setStreamHandler(this)

  }

  override fun onMethodCall(@NonNull call: MethodCall, @NonNull result: Result) {
    when (call.method) {
      "initEngine" -> {
        println("来自安卓222")
        asrConfig = call.arguments as Map<String, String>?
        // 现有的实现
        asrCenter.initEngineBtnClicked()
      }
      "stopEngine" -> {
        // 现有的实现
        asrCenter.stopEngineBtnClicked()
      }
      "uninitEngine" -> {
        // 现有的实现
        asrCenter.uninitEngineBtnClicked()
      }
      "startOrStopEngine" -> {
        // 现有的实现
        asrCenter.startEngineBtnClicked()
      }
      "prepareEnvironment" -> {
       val re = SpeechEngineGenerator.PrepareEnvironment(context, context as Application?)
        println("prepare:===>$re")
      }
      "ttsStartEngineBtnClick" -> {
        println("来自安卓")
        // 空实现
        result.success(null)
      }
      "ttsSynthesis" -> {
        // 空实现
        result.success(null)
      }
      "ttsStopEngineBtnClicked" -> {
        
        // 空实现
        result.success(null)
      }
      "ttsPausePlayback" -> {
        // 空实现
        result.success(null)
      }
      "ttsResumePlayback" -> {
        // 空实现
        result.success(null)
      }
      "ttsInitEngine" -> {
        // 空实现
        result.success(null)
      }
      "ttsUnInitEngine" -> {
        // 空实现
        result.success(null)
      }
      "destoryTtsNovel" -> {
        // 空实现
        result.success(null)
      }
      "destoryAsrVoice" -> {
        // 空实现
        result.success(null)
      }
      else -> {
        result.notImplemented()
      }
    }
  }

  override fun onDetachedFromEngine(binding: FlutterPlugin.FlutterPluginBinding) {
    channel.setMethodCallHandler(null)
  }

  override fun onListen(arguments: Any?, events: EventSink) {
    this.events = events
    // 你可以在这里发送初始事件
//    sendMessageToFlutter("Initial message from Android")
  }

  override fun onCancel(arguments: Any?) {
    this.events = null
  }

  fun sendMessageToFlutter(message: Map<*, *>?) {
    if (events != null) {
      events?.success(message)
    }
  }
}
