import 'package:plugin_platform_interface/plugin_platform_interface.dart';

import 'aivoice_plugin_method_channel.dart';

abstract class AivoicePluginPlatform extends PlatformInterface {
  /// Constructs a AivoicePluginPlatform.
  AivoicePluginPlatform() : super(token: _token);

  static final Object _token = Object();

  static AivoicePluginPlatform _instance = MethodChannelAivoicePlugin();

  /// The default instance of [AivoicePluginPlatform] to use.
  ///
  /// Defaults to [MethodChannelAivoicePlugin].
  static AivoicePluginPlatform get instance => _instance;

  /// Platform-specific implementations should set this with their own
  /// platform-specific class that extends [AivoicePluginPlatform] when
  /// they register themselves.
  static set instance(AivoicePluginPlatform instance) {
    PlatformInterface.verifyToken(instance, _token);
    _instance = instance;
  }

  // 删除了 getPlatformVersion 方法

  // 新增的 initEngine 方法
  Future<void> initEngine(Map<String, dynamic> config);

  // 新增的 stopEngine 方法
  Future<void> stopEngine();

  // 新增的 uninitEngine 方法
  Future<void> uninitEngine();

  // 新增的 startOrStopEngine 方法
  Future<void> startOrStopEngine(bool isBegin);

  // 新增的 prepareEnvironment 方法
  Future<void> prepareEnvironment(Map<String, dynamic> config);

  // 新增的 ttsStartEngineBtnClick 方法
  Future<void> ttsStartEngineBtnClick(Map<String, dynamic> params) {
    throw UnimplementedError('ttsStartEngineBtnClick() has not been implemented.');
  }

  // 新增的 ttsSynthesis 方法
  Future<void> ttsSynthesis(Map<String, dynamic> params) {
    throw UnimplementedError('ttsSynthesis() has not been implemented.');
  }

  // 修改方法名
  Future<void> ttsStopEngineBtnClicked() {
    throw UnimplementedError('ttsStopEngineBtnClicked() has not been implemented.');
  }

  // 新增的 ttsPausePlayback 方法
  Future<void> ttsPausePlayback() {
    throw UnimplementedError('ttsPausePlayback() has not been implemented.');
  }

  // 新增的 ttsResumePlayback 方法
  Future<void> ttsResumePlayback() {
    throw UnimplementedError('ttsResumePlayback() has not been implemented.');
  }

  // 新增的 ttsInitEngine 方法
  Future<void> ttsInitEngine(Map<String, dynamic> config) {
    throw UnimplementedError('ttsInitEngine() has not been implemented.');
  }

  // 新增的 ttsUnInitEngine 方法
  Future<void> ttsUnInitEngine() {
    throw UnimplementedError('ttsUnInitEngine() has not been implemented.');
  }

  // 新增的 destoryTtsNovel 方法
  Future<void> destoryTtsNovel() {
    throw UnimplementedError('destoryTtsNovel() has not been implemented.');
  }

  // 新增的 destoryAsrVoice 方法
  Future<void> destoryAsrVoice() {
    throw UnimplementedError('destoryAsrVoice() has not been implemented.');
  }
}
