import 'package:flutter_test/flutter_test.dart';
import 'package:aivoice_plugin/aivoice_plugin.dart';
import 'package:aivoice_plugin/aivoice_plugin_platform_interface.dart';
import 'package:aivoice_plugin/aivoice_plugin_method_channel.dart';
import 'package:plugin_platform_interface/plugin_platform_interface.dart';

class MockAivoicePluginPlatform
    with MockPlatformInterfaceMixin
    implements AivoicePluginPlatform {

  @override
  Future<String?> getPlatformVersion() => Future.value('42');
}

void main() {
  final AivoicePluginPlatform initialPlatform = AivoicePluginPlatform.instance;

  test('$MethodChannelAivoicePlugin is the default instance', () {
    expect(initialPlatform, isInstanceOf<MethodChannelAivoicePlugin>());
  });

  test('getPlatformVersion', () async {
    AivoicePlugin aivoicePlugin = AivoicePlugin();
    MockAivoicePluginPlatform fakePlatform = MockAivoicePluginPlatform();
    AivoicePluginPlatform.instance = fakePlatform;

    expect(await aivoicePlugin.getPlatformVersion(), '42');
  });
}
