package com.example.aivoice_plugin

import android.content.Context
import androidx.annotation.NonNull
import io.flutter.embedding.engine.plugins.FlutterPlugin
import io.flutter.plugin.common.MethodCall
import io.flutter.plugin.common.MethodChannel
import io.flutter.plugin.common.MethodChannel.MethodCallHandler
import io.flutter.plugin.common.MethodChannel.Result


/** AivoicePlugin */
class AivoicePlugin: FlutterPlugin, MethodCallHandler {


  /// The MethodChannel that will the communication between Flutter and native Android
  ///
  /// This local reference serves to register the plugin with the Flutter Engine and unregister it
  /// when the Flutter Engine is detached from the Activity
  private lateinit var channel : MethodChannel
  private var context: Context? = null

  override fun onAttachedToEngine(@NonNull flutterPluginBinding: FlutterPlugin.FlutterPluginBinding) {
    context = flutterPluginBinding.getApplicationContext();
    channel = MethodChannel(flutterPluginBinding.binaryMessenger, "aivoice_plugin")
    channel.setMethodCallHandler(this)
  }

  override fun onMethodCall(@NonNull call: MethodCall, @NonNull result: Result) {
    when (call.method) {
      "initEngine" -> {
        // 现有的实现
      }
      "stopEngine" -> {
        // 现有的实现
      }
      "uninitEngine" -> {
        // 现有的实现
      }
      "startOrStopEngine" -> {
        // 现有的实现
      }
      "prepareEnvironment" -> {
        // 现有的实现
      }
      "ttsStartEngineBtnClick" -> {
        println("来自安卓")
        // 空实现
        result.success(null)
      }
      "ttsSynthesis" -> {
        // 空实现
        result.success(null)
      }
      "ttsStopEngineBtnClicked" -> {
        
        // 空实现
        result.success(null)
      }
      "ttsPausePlayback" -> {
        // 空实现
        result.success(null)
      }
      "ttsResumePlayback" -> {
        // 空实现
        result.success(null)
      }
      "ttsInitEngine" -> {
        // 空实现
        result.success(null)
      }
      "ttsUnInitEngine" -> {
        // 空实现
        result.success(null)
      }
      "destoryTtsNovel" -> {
        // 空实现
        result.success(null)
      }
      "destoryAsrVoice" -> {
        // 空实现
        result.success(null)
      }
      else -> {
        result.notImplemented()
      }
    }
  }

  override fun onDetachedFromEngine(@NonNull binding: FlutterPlugin.FlutterPluginBinding) {
    channel.setMethodCallHandler(null)
  }
}
