package com.yourcompany.aivoiceplugin;

import androidx.annotation.NonNull;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.MethodChannel.MethodCallHandler;
import io.flutter.plugin.common.MethodChannel.Result;
import java.util.HashMap;
import java.util.Map;

public class AivoicePlugin implements FlutterPlugin, MethodCallHandler, EventChannel.StreamHandler {
  private MethodChannel channel;
  private EventChannel eventChannel;
  private EventChannel.EventSink eventSink;

  @Override
  public void onAttachedToEngine(@NonNull FlutterPluginBinding flutterPluginBinding) {
    channel = new MethodChannel(flutterPluginBinding.getBinaryMessenger(), "aivoice_plugin");
    channel.setMethodCallHandler(this);

    eventChannel = new EventChannel(flutterPluginBinding.getBinaryMessenger(), "aivoice_plugin/events");
    eventChannel.setStreamHandler(this);
  }

  @Override
  public void onMethodCall(@NonNull MethodCall call, @NonNull Result result) {
    // 删除了 getPlatformVersion 方法的实现

    if (call.method.equals("initEngine")) {
      // 处理 config 参数
      Map<String, Object> config = call.arguments();
      // 空实现
      result.success(null);
    } else if (call.method.equals("stopEngine")) {
      // 空实现
      result.success(null);
    } else if (call.method.equals("uninitEngine")) {
      // 空实现
      result.success(null);
    } else if (call.method.equals("startOrStopEngine")) {
      // 空实现
      result.success(null);
    } else if (call.method.equals("prepareEnvironment")) {
      // 空实现
      result.success(null);
    } else {
      result.notImplemented();
    }
  }

  @Override
  public void onDetachedFromEngine(@NonNull FlutterPluginBinding binding) {
    channel.setMethodCallHandler(null);
    eventChannel.setStreamHandler(null);
  }

  @Override
  public void onListen(Object arguments, EventChannel.EventSink events) {
    eventSink = events;
  }

  @Override
  public void onCancel(Object arguments) {
    eventSink = null;
  }

  // 新增的发送 Map<String, dynamic> 方法
  private void sendMapToFlutter(Map<String, Object> message) {
    if (eventSink != null) {
      eventSink.success(message);
    }
  }
}