import 'dart:async';

import 'package:aivoice_plugin/aivoice_plugin.dart';
import 'package:flutter/material.dart';
import 'package:permission_handler/permission_handler.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  final String _platformVersion = 'Unknown';
  final _aivoicePlugin = AivoicePlugin();

  String _text = '';

  final configMap = {
    "appId": "2301072440",
    "token": "Bearer;75UvJCpxRjTCppqQUkQ-o-4UfjnCgVmp",
    "voiceType": "BV213_w5H18f6VbKnhg3Ph",
    "voice": "灿灿"
  };

  @override
  void initState() {
    super.initState();
    initPlatformState();

    _aivoicePlugin.onAsrResultReceived.listen((event) {
      final a = event["finish"];

      final b = event["playWords"];

      setState(() {
        _text = event["text"] ?? "$a";
      });

      // _text = b ?? "$a";

      // print(event["text"]);
    });
    _aivoicePlugin.prepareEnvironment({"appId": "2301072440"});
  }

  ///申请权限麦克风
  static Future<bool> requestPermissionMicrophone() async {
    final permissionMicrophone = await Permission.microphone.status;

    if (permissionMicrophone == PermissionStatus.granted) {
      return true;
    }
    // 申请权限
    final Map<Permission, PermissionStatus> permissions = await [
      Permission.microphone,
    ].request();
    final status = permissions[Permission.microphone] == PermissionStatus.granted;
    if (!status) {
      // askOpenAppSettings(content: "录制需要麦克风权限");
    }
    return status;
  }

  // Platform messages are asynchronous, so we initialize in an async method.
  Future<void> initPlatformState() async {
    if (!mounted) return;

    setState(() {});
  }

  @override
  Widget build(BuildContext context) {
    var ttsView = Row(
      children: [
        TextButton(
            onPressed: () {
              _aivoicePlugin.ttsInitEngine(configMap);
              requestPermissionMicrophone();
            },
            child: const Text('init')),
        TextButton(
            onPressed: () {
              _aivoicePlugin.ttsStartEngineBtnClick(
                  {"text": "引擎启动成功，收到该回调后，在单次合成场景下收到该回调时语音合成已经开始，同时数据字段为该次请求的请求 ID; 连续合成场景下还需要再发送合成指令，才真正的开始合成。"});
            },
            child: const Text('start')),
        TextButton(
            onPressed: () {
              _aivoicePlugin.ttsStopEngineBtnClicked();
            },
            child: const Text('stop')),
        TextButton(
            onPressed: () {
              _aivoicePlugin.ttsSynthesis({});
            },
            child: const Text('合成')),
        TextButton(
            onPressed: () {
              _aivoicePlugin.ttsStartEngineBtnClick(
                  {"text": "引擎启动成功，收到该回调后，在单次合成场景下收到该回调时语音合成已经开始，同时数据字段为该次请求的请求 ID; 连续合成场景下还需要再发送合成指令，才真正的开始合成。"});
              _aivoicePlugin.ttsSynthesis({});
            },
            child: const Text('一件开始'))
        // TextButton(
        //     onPressed: () {
        //       _aivoicePlugin.initEngine(configMap);
        //     },
        //     child: const Text('init')),
        // TextButton(
        //     onPressed: () {
        //       _aivoicePlugin.startOrStopEngine(true);
        //     },
        //     child: const Text('start')),
        // TextButton(
        //     onPressed: () {
        //       _aivoicePlugin.stopEngine();
        //     },
        //     child: const Text('stop')),
      ],
    );
    var asrView = Row(
      children: [
        TextButton(
            onPressed: () {
              _aivoicePlugin.initEngine(configMap);
              requestPermissionMicrophone();
            },
            child: const Text('init2')),
        TextButton(
            onPressed: () {
              _aivoicePlugin.startOrStopEngine(true);
            },
            child: const Text('start')),
        TextButton(
            onPressed: () {
              _aivoicePlugin.stopEngine();
            },
            child: const Text('stop')),

        // TextButton(
        //     onPressed: () {
        //       _aivoicePlugin.initEngine(configMap);
        //     },
        //     child: const Text('init')),
        // TextButton(
        //     onPressed: () {
        //       _aivoicePlugin.startOrStopEngine(true);
        //     },
        //     child: const Text('start')),
        // TextButton(
        //     onPressed: () {
        //       _aivoicePlugin.stopEngine();
        //     },
        //     child: const Text('stop')),
      ],
    );
    return MaterialApp(
      home: Scaffold(
        appBar: AppBar(
          title: const Text('Plugin example app'),
        ),
        body: Center(
          child: Row(
            children: [
              Expanded(child: Text('识别结果是: $_text')),
            ],
          ),
        ),
        floatingActionButton: asrView,
      ),
    );
  }
}
