import 'package:flutter/services.dart';

import 'aivoice_plugin_platform_interface.dart';

class AivoicePlugin {
  // 删除了 getPlatformVersion 方法

  // 新增的 initEngine 方法
  Future<void> initEngine(Map<String, dynamic> config) {
    return AivoicePluginPlatform.instance.initEngine(config);
  }

  // 新增的 stopEngine 方法
  Future<void> stopEngine() {
    return AivoicePluginPlatform.instance.stopEngine();
  }

  // 新增的 uninitEngine 方法
  Future<void> uninitEngine() {
    return AivoicePluginPlatform.instance.uninitEngine();
  }

  // 新增的 startOrStopEngine 方法
  Future<void> startOrStopEngine(bool isBegin) {
    return AivoicePluginPlatform.instance.startOrStopEngine(isBegin);
  }

  // 新增的 prepareEnvironment 方法
  Future<void> prepareEnvironment(Map<String, dynamic> config) {
    return AivoicePluginPlatform.instance.prepareEnvironment(config);
  }

  // 新增的监听方法
  static const EventChannel _eventChannel = EventChannel('aivoice_plugin/events');

  Stream<Map<String, dynamic>> get onAsrResultReceived {
    return _eventChannel.receiveBroadcastStream().map((event) => Map<String, dynamic>.from(event));
  }

  // 更改方法名
  Future<void> ttsStartEngineBtnClick(Map<String, dynamic> params) {
    return AivoicePluginPlatform.instance.ttsStartEngineBtnClick(params);
  }

  // 新增的 ttsSynthesis 方法
  Future<void> ttsSynthesis(Map<String, dynamic> params) {
    return AivoicePluginPlatform.instance.ttsSynthesis(params);
  }

  // 修改方法名
  Future<void> ttsStopEngineBtnClicked() {
    return AivoicePluginPlatform.instance.ttsStopEngineBtnClicked();
  }

  // 新增的 ttsPausePlayback 方法
  Future<void> ttsPausePlayback() {
    return AivoicePluginPlatform.instance.ttsPausePlayback();
  }

  // 新增的 ttsResumePlayback 方法
  Future<void> ttsResumePlayback() {
    return AivoicePluginPlatform.instance.ttsResumePlayback();
  }

  // 新增的 ttsInitEngine 方法
  Future<void> ttsInitEngine(Map<String, dynamic> config) {
    return AivoicePluginPlatform.instance.ttsInitEngine(config);
  }

  // 新增的 ttsUnInitEngine 方法
  Future<void> ttsUnInitEngine() {
    return AivoicePluginPlatform.instance.ttsUnInitEngine();
  }

  // 新增的 destoryTtsNovel 方法
  Future<void> destoryTtsNovel() {
    return AivoicePluginPlatform.instance.destoryTtsNovel();
  }

  // 新增的 destoryAsrVoice 方法
  Future<void> destoryAsrVoice() {
    return AivoicePluginPlatform.instance.destoryAsrVoice();
  }
}
