import UIKit
import Flutter
import aivoice_plugin

@UIApplicationMain
@objc class AppDelegate: FlutterAppDelegate {
  override func application(
    _ application: UIApplication,
    didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?
  ) -> Bool {
    GeneratedPluginRegistrant.register(with: self)
    let ret =  SpeechEngine.prepareEnvironment();
      if ret {
          setupResourceManager()
      }
    return super.application(application, didFinishLaunchingWithOptions: launchOptions)
  }
    
    
    
    func setupResourceManager() {
       let ins = SpeechResourceManager.shareInstance()
        ins.setAppId(SDEF_APPID)
        ins.setAppVersion("1.0.0")
        if let documentDirectory = FileManager.default.urls(for: .documentDirectory, in: .userDomainMask).first {
            let modelsPath = documentDirectory.appendingPathComponent("models").path
            ins.setRootPath(modelsPath)
        }

        ins.setOnlineModelEnable(true)
        ins.setup()
        
        
    }
}


