#import "AivoicePlugin.h"
#import "VoiceAsr.h"

@interface AivoicePlugin () <FlutterStreamHandler, VoiceAsrDelegate>
@property (nonatomic, strong) FlutterEventSink eventSink;

@property(nonatomic, strong)VoiceAsr * voiceAsr;
@end

@implementation AivoicePlugin
+ (void)registerWithRegistrar:(NSObject<FlutterPluginRegistrar>*)registrar {
  FlutterMethodChannel* channel = [FlutterMethodChannel
      methodChannelWithName:@"aivoice_plugin"
            binaryMessenger:[registrar messenger]];
  AivoicePlugin* instance = [[AivoicePlugin alloc] init];
  [registrar addMethodCallDelegate:instance channel:channel];
    
  

  FlutterEventChannel* eventChannel = [FlutterEventChannel
      eventChannelWithName:@"aivoice_plugin/events"
            binaryMessenger:[registrar messenger]];
  [eventChannel setStreamHandler:instance];
  
}

- (void)handleMethodCall:(FlutterMethodCall*)call result:(FlutterResult)result {
  // 删除了 getPlatformVersion 方法的实现

  if ([@"initEngine" isEqualToString:call.method]) {
      [self.voiceAsr initEngine];
    result(nil);
  } else if ([@"stopEngine" isEqualToString:call.method]) {
      [self.voiceAsr stopEngineBtnClicked];
    result(nil);
  } else if ([@"uninitEngine" isEqualToString:call.method]) {
      [self.voiceAsr uninitEngine];
    result(nil);
  } else if ([@"startOrStopEngine" isEqualToString:call.method]) {
     
//      BOOL arg =  [NSNumber numberWithBool:call.arguments];
      [self.voiceAsr startEngineBtnClicked];
    result(nil);
  } else if ([@"prepareEnvironment" isEqualToString:call.method]) {
      [VoiceAsr prepareEnvironment:call.arguments];

      result(nil);
  } else {
    result(FlutterMethodNotImplemented);
  }
}

- (FlutterError* _Nullable)onListenWithArguments:(id _Nullable)arguments eventSink:(FlutterEventSink)events {
  self.eventSink = events;
  return nil;
}

- (FlutterError* _Nullable)onCancelWithArguments:(id _Nullable)arguments {
  self.eventSink = nil;
  return nil;
}

// 新增的发送 Map<String, dynamic> 方法
- (void)sendMessageToFlutter:(NSDictionary*)message {
  if (self.eventSink) {
    self.eventSink(message);
  }
}

- (VoiceAsr *)voiceAsr {
    if(!_voiceAsr) {
        _voiceAsr = [[VoiceAsr alloc] initWithDelegate:self];
    }
    return _voiceAsr;
}


- (void)onRecieve:(nonnull NSDictionary *)message { 
    [self sendMessageToFlutter:message];
}


@end
