#import "AivoicePlugin.h"
#import "VoiceAsr.h"
#import "TtsNovel.h"

@interface AivoicePlugin () <FlutterStreamHandler, VoiceAsrDelegate, TtsNovelDelegate>
@property (nonatomic, strong) FlutterEventSink eventSink;

@property(nonatomic, strong)VoiceAsr * voiceAsr;

@property(nonatomic, strong)TtsNovel * ttsNovel;

@property(nonatomic, strong)NSDictionary * config;

@property(nonatomic, strong)NSDictionary * ttsNovelconfig;
@end

@implementation AivoicePlugin
+ (void)registerWithRegistrar:(NSObject<FlutterPluginRegistrar>*)registrar {
    FlutterMethodChannel* channel = [FlutterMethodChannel
                                     methodChannelWithName:@"aivoice_plugin"
                                     binaryMessenger:[registrar messenger]];
    AivoicePlugin* instance = [[AivoicePlugin alloc] init];
    [registrar addMethodCallDelegate:instance channel:channel];
    
    
    
    FlutterEventChannel* eventChannel = [FlutterEventChannel
                                         eventChannelWithName:@"aivoice_plugin/events"
                                         binaryMessenger:[registrar messenger]];
    [eventChannel setStreamHandler:instance];
    
}

- (void)handleMethodCall:(FlutterMethodCall*)call result:(FlutterResult)result {
    // 删除了 getPlatformVersion 方法的实现
    
    if ([@"initEngine" isEqualToString:call.method]) {
        self.config = call.arguments;
        [self.voiceAsr initEngineWithConfig:call.arguments];
        result(nil);
    } else if ([@"stopEngine" isEqualToString:call.method]) {
        [self.voiceAsr stopEngineBtnClicked];
        result(nil);
    } else if ([@"uninitEngine" isEqualToString:call.method]) {
        [self.voiceAsr uninitEngine];
        result(nil);
    } else if ([@"startOrStopEngine" isEqualToString:call.method]) {
        [self.voiceAsr startEngineBtnClicked];
        result(nil);
    } else if ([@"prepareEnvironment" isEqualToString:call.method]) {
        [VoiceAsr prepareEnvironment:call.arguments];
        
        result(nil);
    } else if ([@"ttsStartEngineBtnClick" isEqualToString:call.method]) {
        [self.ttsNovel startEngineBtnClick:call.arguments[@"text"]];
        result(nil);
    } else if ([@"ttsSynthesis" isEqualToString:call.method]) {
        [self.ttsNovel synthesis];
        result(nil);
    } else if ([@"ttsStopEngineBtnClicked" isEqualToString:call.method]) {
        [self.ttsNovel stopEngineBtnClicked];
        result(nil);
    } else if ([@"ttsPausePlayback" isEqualToString:call.method]) {
        [self.ttsNovel pausePlayback];
        result(nil);
    } else if ([@"ttsResumePlayback" isEqualToString:call.method]) {
        [self.ttsNovel resumePlayback];
        result(nil);
    } else if ([@"ttsInitEngine" isEqualToString:call.method]) {
        self.ttsNovelconfig = call.arguments;
        [self.ttsNovel switchEngine];
        result(nil);
    } else if ([@"ttsUnInitEngine" isEqualToString:call.method]) {
        [self.ttsNovel switchEngine];
        result(nil);
    } else if ([@"destoryTtsNovel" isEqualToString:call.method]) {
        [self destoryTtsNovel];
        result(nil);
    } else if ([@"destoryAsrVoice" isEqualToString:call.method]) {
        [self destoryVoiceAsr];
        result(nil);
    } else {
        result(FlutterMethodNotImplemented);
    }
}

- (FlutterError* _Nullable)onListenWithArguments:(id _Nullable)arguments eventSink:(FlutterEventSink)events {
    self.eventSink = events;
    return nil;
}

- (FlutterError* _Nullable)onCancelWithArguments:(id _Nullable)arguments {
    self.eventSink = nil;
    return nil;
}

// 新增的发送 Map<String, dynamic> 方法
- (void)sendMessageToFlutter:(NSDictionary*)message {
    if (self.eventSink) {
        self.eventSink(message);
    }
}

- (void) destoryVoiceAsr {
    [self.voiceAsr destroyEngine];
    _voiceAsr = nil;
    
}
- (void) destoryTtsNovel {
    [self.ttsNovel destroyEngine];
    _ttsNovel = nil;
    
}

- (VoiceAsr *)voiceAsr {
    if(!_voiceAsr) {
        _voiceAsr = [[VoiceAsr alloc] initWithDelegate:self config:self.config];
    }
    return _voiceAsr;
}
- (TtsNovel *)ttsNovel {
    if(!_ttsNovel) {
        _ttsNovel = [[TtsNovel alloc] initWithDelegate:self config:self.ttsNovelconfig];
    }
    return _ttsNovel;
}


- (void)onRecieve:(nonnull NSDictionary *)message {
    [self sendMessageToFlutter:message];
}



@end
