//
//  SpeechMessageProcessor.h
//  SpeechDemo
//
//  Created by bytedance on 2022/4/18.
//  Copyright © 2022 fangweiwei. All rights reserved.
//

#define SpeechMessageProcessor_h

#import <Foundation/Foundation.h>
#import <SpeechEngineToB/SpeechEngine.h>


@interface CallbackMessage : NSObject

@property (nonatomic, assign) SEMessageType type;
@property (nonatomic, assign) NSData* data;

@end


@protocol SpeechMessageProcessor <NSObject>

- (void)processMessage:(CallbackMessage*)message;

@end


@interface SpeechMessageDispatcher : NSObject <SpeechEngineDelegate>

- (void)onMessageWithType:(SEMessageType)type andData:(NSData *)data;

- (instancetype)initWithDelegate:(id<SpeechMessageProcessor>)delegate;

- (void)destroyDispatcher;

@end

