//
//  VoiceAsr.h
//  aivoice_plugin
//
//  Created by benben on 2024/9/7.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol VoiceAsrDelegate <NSObject>

- (void)onRecieve:(NSDictionary*)message;

@end

@interface VoiceAsr : NSObject

- (instancetype)initWithDelegate:(id<VoiceAsrDelegate>)delegate
                          config:(NSDictionary *)config;

+ (void)prepareEnvironment:(NSDictionary *)config;

- (void)initEngineWithConfig:(NSDictionary *)config;

- (void)uninitEngine;

- (void) destroyEngine;

- (void)startEngineBtnClicked;

- (void)stopEngineBtnClicked;

- (void)startEngineByLongPress:(BOOL)isBegin;

@end

NS_ASSUME_NONNULL_END
