#import "AivoicePlugin.h"

@interface AivoicePlugin () 

@end

@implementation AivoicePlugin
+ (void)registerWithRegistrar:(NSObject<FlutterPluginRegistrar>*)registrar {
  FlutterMethodChannel* channel = [FlutterMethodChannel
      methodChannelWithName:@"aivoice_plugin"
            binaryMessenger:[registrar messenger]];
  AivoicePlugin* instance = [[AivoicePlugin alloc] init];
  [registrar addMethodCallDelegate:instance channel:channel];
}

- (void)handleMethodCall:(FlutterMethodCall*)call result:(FlutterResult)result {
  if ([@"getPlatformVersion" isEqualToString:call.method]) {
    result([@"iOS " stringByAppendingString:[[UIDevice currentDevice] systemVersion]]);
  } else if ([@"initEngine" isEqualToString:call.method]) {
    // 空实现
    result(nil);
  } else {
    result(FlutterMethodNotImplemented);
  }
}

@end
