import 'package:flutter/foundation.dart';
import 'package:flutter/services.dart';

import 'aivoice_plugin_platform_interface.dart';

/// An implementation of [AivoicePluginPlatform] that uses method channels.
class MethodChannelAivoicePlugin extends AivoicePluginPlatform {
  /// The method channel used to interact with the native platform.
  @visibleForTesting
  final methodChannel = const MethodChannel('aivoice_plugin');

  @override
  Future<String?> getPlatformVersion() async {
    final version = await methodChannel.invokeMethod<String>('getPlatformVersion');
    return version;
  }
}
