import 'package:plugin_platform_interface/plugin_platform_interface.dart';

import 'aivoice_plugin_method_channel.dart';

abstract class AivoicePluginPlatform extends PlatformInterface {
  /// Constructs a AivoicePluginPlatform.
  AivoicePluginPlatform() : super(token: _token);

  static final Object _token = Object();

  static AivoicePluginPlatform _instance = MethodChannelAivoicePlugin();

  /// The default instance of [AivoicePluginPlatform] to use.
  ///
  /// Defaults to [MethodChannelAivoicePlugin].
  static AivoicePluginPlatform get instance => _instance;

  /// Platform-specific implementations should set this with their own
  /// platform-specific class that extends [AivoicePluginPlatform] when
  /// they register themselves.
  static set instance(AivoicePluginPlatform instance) {
    PlatformInterface.verifyToken(instance, _token);
    _instance = instance;
  }

  Future<String?> getPlatformVersion();

  // 新增的 initEngine 方法
  Future<void> initEngine(Map<String, dynamic> config);
}
