import 'dart:async';

import 'package:aivoice_plugin/aivoice_plugin.dart';
import 'package:flutter/material.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  final String _platformVersion = 'Unknown';
  final _aivoicePlugin = AivoicePlugin();

  String _text = '';

  @override
  void initState() {
    super.initState();
    initPlatformState();

    _aivoicePlugin.onAsrResultReceived.listen((event) {
      setState(() {
        _text = event["text"];
      });
      // print(event["text"]);
    });
    // _aivoicePlugin.initEngine({});
  }

  // Platform messages are asynchronous, so we initialize in an async method.
  Future<void> initPlatformState() async {
    if (!mounted) return;

    setState(() {});
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: Scaffold(
        appBar: AppBar(
          title: const Text('Plugin example app'),
        ),
        body: Center(
          child: Row(
            children: [
              Expanded(child: Text('识别结果是: $_text')),
            ],
          ),
        ),
        floatingActionButton: Row(
          children: [
            TextButton(
                onPressed: () {
                  _aivoicePlugin.initEngine({});
                },
                child: const Text('init')),
            TextButton(
                onPressed: () {
                  _aivoicePlugin.startOrStopEngine(true);
                },
                child: const Text('start')),
            TextButton(
                onPressed: () {
                  _aivoicePlugin.stopEngine();
                },
                child: const Text('stop')),
          ],
        ),
      ),
    );
  }
}
