import 'package:flutter/foundation.dart';
import 'package:flutter/services.dart';

import 'aivoice_plugin_platform_interface.dart';

/// An implementation of [AivoicePluginPlatform] that uses method channels.
class MethodChannelAivoicePlugin extends AivoicePluginPlatform {
  /// The method channel used to interact with the native platform.
  @visibleForTesting
  final methodChannel = const MethodChannel('aivoice_plugin');

  // 删除了 getPlatformVersion 方法

  @override
  Future<void> initEngine(Map<String, dynamic> config) async {
    await methodChannel.invokeMethod<void>('initEngine', config);
  }

  @override
  Future<void> stopEngine() async {
    await methodChannel.invokeMethod<void>('stopEngine');
  }

  @override
  Future<void> uninitEngine() async {
    await methodChannel.invokeMethod<void>('uninitEngine');
  }

  @override
  Future<void> startOrStopEngine(bool isBegin) async {
    await methodChannel.invokeMethod<void>('startOrStopEngine', {'isBegin': isBegin});
  }
}
