import 'package:flutter/services.dart';

import 'aivoice_plugin_platform_interface.dart';

class MethodChannelAivoicePlugin extends AivoicePluginPlatform {
  final MethodChannel _channel = const MethodChannel('aivoice_plugin');

  @override
  Future<void> initEngine(Map<String, dynamic> config) {
    return _channel.invokeMethod<void>('initEngine', config);
  }

  @override
  Future<void> stopEngine() {
    return _channel.invokeMethod<void>('stopEngine');
  }

  @override
  Future<void> uninitEngine() {
    return _channel.invokeMethod<void>('uninitEngine');
  }

  @override
  Future<void> startOrStopEngine(bool isBegin) {
    return _channel.invokeMethod<void>('startOrStopEngine', {'isBegin': isBegin});
  }
}
