package com.example.aivoice_plugin

import android.app.Application
import android.content.Context
import android.util.Log
import androidx.annotation.NonNull
import com.bytedance.speech.speechengine.SpeechEngineGenerator
import io.flutter.embedding.engine.plugins.FlutterPlugin
import io.flutter.plugin.common.EventChannel
import io.flutter.plugin.common.EventChannel.EventSink
import io.flutter.plugin.common.MethodCall
import io.flutter.plugin.common.MethodChannel
import io.flutter.plugin.common.MethodChannel.MethodCallHandler
import io.flutter.plugin.common.MethodChannel.Result


/** AivoicePlugin */
class AivoicePlugin: FlutterPlugin, MethodCallHandler, EventChannel.StreamHandler {


  /// The MethodChannel that will the communication between Flutter and native Android
  ///
  /// This local reference serves to register the plugin with the Flutter Engine and unregister it
  /// when the Flutter Engine is detached from the Activity
  private lateinit var channel : MethodChannel
  private var context: Context? = null

  private  var asrConfig : Map<String, String>? = null

  private  var ttsConfig : Map<String, String>? = null

  private val eventChannel: EventChannel? = null
  private var events: EventSink? = null



  private val asrCenter: AsrCenter by lazy {
    AsrCenter(asrConfig, context, AsrCenter.AsrCenterCallback {
      sendMessageToFlutter(it)
    })
  }

  private val ttsNovelCenter: TtsNovelCenter by lazy {
    TtsNovelCenter(ttsConfig, context, TtsNovelCenter.TtsNovelCenterCallback {
      sendMessageToFlutter(it)
    })
  }

  override fun onAttachedToEngine(@NonNull flutterPluginBinding: FlutterPlugin.FlutterPluginBinding) {
    context = flutterPluginBinding.applicationContext;
    channel = MethodChannel(flutterPluginBinding.binaryMessenger, "aivoice_plugin")
    channel.setMethodCallHandler(this)
    val eventChannel = EventChannel(flutterPluginBinding.binaryMessenger, "aivoice_plugin/events")
    eventChannel.setStreamHandler(this)

  }

  override fun onMethodCall(@NonNull call: MethodCall, @NonNull result: Result) {
    when (call.method) {
      "initEngine" -> {
        try {
          asrConfig = call.arguments as Map<String, String>?
          asrCenter.initEngineBtnClicked()
          result.success(true)
        } catch (e: Exception) {
          result.error("INIT_ERROR", e.message, null)
        }
      }
      "stopEngine" -> {
        try {
          asrCenter.stopEngineBtnClicked()
          result.success(true)
        } catch (e: Exception) {
          result.error("STOP_ERROR", e.message, null)
        }
      }
      "uninitEngine" -> {
        try {
          asrCenter.uninitEngineBtnClicked()
          result.success(true)
        } catch (e: Exception) {
          result.error("UNINIT_ERROR", e.message, null)
        }
      }
      "startOrStopEngine" -> {
        try {
          Log.i("aivoic_plugin", "开始识别了")
          asrCenter.startEngineBtnClicked()
          result.success(true)
        } catch (e: Exception) {
          result.error("START_ERROR", e.message, null)
        }
      }
      "prepareEnvironment" -> {
        try {
          val re = SpeechEngineGenerator.PrepareEnvironment(context, context as Application?)
          result.success(re)
        } catch (e: Exception) {
          result.error("PREPARE_ERROR", e.message, null)
        }
      }
      "ttsStartEngineBtnClick" -> {
        try {
          ttsNovelCenter.startEngineBtnClicked(call.argument("text"))
          result.success(true)
        } catch (e: Exception) {
          result.error("TTS_START_ERROR", e.message, null)
        }
      }
      "ttsSynthesis" -> {
        try {
          ttsNovelCenter.synthesisBtnClicked()
          result.success(true)
        } catch (e: Exception) {
          result.error("TTS_SYNTHESIS_ERROR", e.message, null)
        }
      }
      "ttsStopEngineBtnClicked" -> {
        try {
          ttsNovelCenter.stopEngineBtnClicked()
          result.success(true)
        } catch (e: Exception) {
          result.error("TTS_STOP_ERROR", e.message, null)
        }
      }
      "ttsPausePlayback" -> {
        try {
          ttsNovelCenter.pausePlayback()
          result.success(true)
        } catch (e: Exception) {
          result.error("TTS_PAUSE_ERROR", e.message, null)
        }
      }
      "ttsResumePlayback" -> {
        try {
          ttsNovelCenter.resumePlayback()
          result.success(true)
        } catch (e: Exception) {
          result.error("TTS_RESUME_ERROR", e.message, null)
        }
      }
      "ttsInitEngine" -> {
        try {
          ttsConfig = call.arguments()
          ttsNovelCenter.initEngineInternal()
          result.success(true)
        } catch (e: Exception) {
          result.error("TTS_INIT_ERROR", e.message, null)
        }
      }
      "ttsUnInitEngine" -> {
        try {
          ttsNovelCenter.uninitEngine()
          result.success(true)
        } catch (e: Exception) {
          result.error("TTS_UNINIT_ERROR", e.message, null)
        }
      }
      "destoryTtsNovel" -> {
        try {
          ttsNovelCenter.destroy()
          result.success(true)
        } catch (e: Exception) {
          result.error("TTS_DESTROY_ERROR", e.message, null)
        }
      }
      "destoryAsrVoice" -> {
        try {
          asrCenter.destroy()
          result.success(true)
        } catch (e: Exception) {
          result.error("ASR_DESTROY_ERROR", e.message, null)
        }
      }
      else -> {
        result.notImplemented()
      }
    }
  }

  override fun onDetachedFromEngine(binding: FlutterPlugin.FlutterPluginBinding) {
    channel.setMethodCallHandler(null)
  }

  override fun onListen(arguments: Any?, events: EventSink) {
    this.events = events
    // 你可以在这里发送初始事件
//    sendMessageToFlutter("Initial message from Android")
  }

  override fun onCancel(arguments: Any?) {
    this.events = null
  }

  private fun sendMessageToFlutter(message: Map<*, *>?) {
    if (events != null) {
      context.run {  }
      events?.success(message)
    }
  }
}
