//
//  SpeechMessageProcessor.m
//  SpeechDemo
//
//  Created by bytedance on 2022/4/18.
//  Copyright © 2022 fangweiwei. All rights reserved.
//

#import "SpeechMessageProcessor.h"

@implementation CallbackMessage
@end


@interface SpeechMessageDispatcher()
// separate thread to process callback message
@property (nonatomic, strong) NSThread *messageProcessThread;
@property (nonatomic, weak) id<SpeechMessageProcessor> messageProcessorDelegate;

@end

@implementation SpeechMessageDispatcher

- (instancetype)init {
    return [self initWithDelegate:nil];
}

- (instancetype)initWithDelegate:(id<SpeechMessageProcessor>)delegate {
    self = [super init];
    if (self) {
        self.messageProcessorDelegate = delegate;
        self.messageProcessThread = [[NSThread alloc] initWithTarget:self selector:@selector(messageProcessThreadEntryPoint:) object:nil];
        if (self.messageProcessThread) {
            [self.messageProcessThread start];
        } else {
            self = nil;
        }
    }
    return self;
}


- (void)onMessageWithType:(SEMessageType)type andData:(NSData *)data {
    if (self.messageProcessorDelegate && self.messageProcessThread) {
        CallbackMessage* message = [[CallbackMessage alloc] init];
        message.type = type;
        message.data = data;
        [self performSelector:@selector(processMessage:) onThread:self.messageProcessThread withObject:message waitUntilDone:YES];
    }
}

- (void)messageProcessThreadEntryPoint:(id)object {
    @autoreleasepool {
        [[NSThread currentThread] setName:@"SpeechMessageProcessor"];
        NSRunLoop *runLoop = [NSRunLoop currentRunLoop];
        [runLoop addPort:[NSMachPort port] forMode:NSDefaultRunLoopMode];
        [runLoop run];
    }
}

- (void)processMessage:(CallbackMessage*)message {
    if (self.messageProcessorDelegate) {
        [self.messageProcessorDelegate processMessage:message];
    }
}

- (void) destroyDispatcher {
    if (self.messageProcessThread) {
        [self.messageProcessThread cancel];
    }
}

@end
