//
//  TZCashSDK.h
//  TZCashSDK
//
//  Created by Shirley on 6/23/20.
//  Copyright © 2020 Shirley. All rights reserved.
//

#import <Foundation/Foundation.h>

// 页面推出类型
typedef enum {
    CashSDKPageLaunchPresent,
    CashSDKPageLaunchPush,
} CashSDKPageLaunchTypes;

// 开发环境类型
typedef enum {
    CashSDKEnvironmentUat,
    CashSDKPageLaunchReg,
    CashSDKPageLaunchProd,
} CashSDKEnvironmentTypes;

@protocol TZCashSDKDelegate<NSObject>

// 实现app支付
- (void)TZAppPay:(NSString *_Nullable)payStr;

// 实现小程序支付
- (void)miniProgramPay:(NSString *_Nullable)payStr;

@end


@interface TZCashSDK : NSObject

//当前代理
@property (nonatomic, weak, nullable) id <TZCashSDKDelegate> delegate;

@property (nonatomic, assign) CashSDKPageLaunchTypes launchType;


/*
 收银台初始化方法
 */
+(instancetype _Nullable )shareInstance;
/*
 调用支付收银台
 environment:调用收银台的环境
 orderInf:调用收银台传入的订单相关信息
 launchType:页面出现方式，默认为CashSDKPageLaunchPresent
 controller:当前的rootViewController，如果launchType为CashSDKPageLaunchPush，则必须传入NavigationController
 schemeStr:调用支付的app注册在info.plist中的scheme
 payfinishBlock:收银台回调
 orderStatus:当前订单的状态 10 初始状态，70 失败，80关闭 90成功
 
 NSMutableDictionary *orderInf = [NSMutableDictionary dictionary];
 [orderInf setObject:orderFlowNo forKey:@"orderNoList"];//预下单返回的订单流水号
 [orderInf setObject:businessCstNo forKey:@"businessCstNo"];//预下单的业务平台客户号
 [orderInf setObject:platMerCstNo forKey:@"platMerCstNo"];//预下单的平台商户号
 TZCashSDK *cashsdk = [TZCashSDK shareInstance];
 [cashsdk callPaymentWithOrderInfo:orderInf payfinishBlock:^(NSString *orderStatus) {
     NSLog(@"%@",orderStatus);
 }];
 */
-(void)callPaymentWithEnvironmentType:(CashSDKEnvironmentTypes)environmentType orderInfo:(NSMutableDictionary *_Nullable)orderInfo launchType:(CashSDKPageLaunchTypes)launchType rootController:(UIViewController * _Nullable)controller fromScheme:(NSString * _Nullable)schemeStr payfinishBlock:(void(^_Nullable)(NSString * _Nonnull orderStatus))payfinishBlock;
/**
 app结果通知
 */
-(void)notiAppPayResult:(NSString *_Nullable)payResult;

/*
处理支付结果
*/
-(void)handlePaymentResult:(NSURL * _Nullable)url;

@end
