import 'package:flutter/foundation.dart';
import 'package:flutter/services.dart';

import 'tzcash_platform_interface.dart';

/// An implementation of [TzcashPlatform] that uses method channels.
class MethodChannelTzcash extends TzcashPlatform {
  /// The method channel used to interact with the native platform.
  @visibleForTesting
  final methodChannel = const MethodChannel('tzcash');

  @override
  Future<String?> getPlatformVersion() async {
    final version = await methodChannel.invokeMethod<String>('getPlatformVersion');
    return version;
  }

  @override
  Future<String?> callPayment(Map<String, dynamic> orderInfo) async {
    final version = await methodChannel.invokeMethod<String>('callPayment', orderInfo);
    return version;
  }
}
