#import "TzcashPlugin.h"
#import "TZCashSDK.h"

@interface TzcashPlugin()<TZCashSDKDelegate>

@property(nonatomic, strong) FlutterMethodChannel* channel;

@end


@implementation TzcashPlugin

+ (void)registerWithRegistrar:(NSObject<FlutterPluginRegistrar>*)registrar {
    FlutterMethodChannel* channel = [FlutterMethodChannel
                                     methodChannelWithName:@"tzcash"
                                     binaryMessenger:[registrar messenger]];
    TzcashPlugin* instance = [[TzcashPlugin alloc] init];
    instance.channel = channel;
    [TZCashSDK shareInstance].delegate = instance;
    [registrar addMethodCallDelegate:instance channel:channel];
}

- (void)handleMethodCall:(FlutterMethodCall*)call result:(FlutterResult)result {
    
    if ([@"getPlatformVersion" isEqualToString:call.method]) {
        result([@"iOS " stringByAppendingString:[[UIDevice currentDevice] systemVersion]]);
    } else if ([@"callPayment" isEqualToString:call.method]) {
        NSMutableDictionary *arguments = call.arguments;
        CashSDKEnvironmentTypes env = [arguments[@"env"] integerValue] == 2 ? CashSDKPageLaunchProd : CashSDKPageLaunchReg;
        UIViewController *rootVC = [UIApplication sharedApplication].keyWindow.rootViewController;
        NSMutableDictionary *order = [NSMutableDictionary dictionaryWithDictionary:arguments[@"orderInfo"]];
        //单独处理订单号参数
        order[@"orderNoList"] = order[@"orderFlowNo"];
        [[TZCashSDK shareInstance] callPaymentWithEnvironmentType:env
                                                        orderInfo:order
                                                       launchType:CashSDKPageLaunchPresent
                                                   rootController:rootVC
                                                       fromScheme:@"aistory2024"
                                                   payfinishBlock:^(NSString * _Nonnull orderStatus) {
            //10:待支付 60:处理中 70:失败 80:关闭 90:成功
            result(orderStatus);
            
        }];
    } else {
        result(FlutterMethodNotImplemented);
    }
}

#pragma mark - TZCashSDKDelegate
- (void)TZAppPay:(NSString *)payStr {
    [self.channel invokeMethod:@"onTZAppPay" arguments:payStr];
}

- (void)miniProgramPay:(NSString *)payStr {
    [self.channel invokeMethod:@"onMiniProgramPay" arguments:payStr];
}

@end
