import 'package:plugin_platform_interface/plugin_platform_interface.dart';

import 'tzcash_method_channel.dart';

abstract class TzcashPlatform extends PlatformInterface {
  /// Constructs a TzcashPlatform.
  TzcashPlatform() : super(token: _token);

  static final Object _token = Object();

  static TzcashPlatform _instance = MethodChannelTzcash();

  /// The default instance of [TzcashPlatform] to use.
  ///
  /// Defaults to [MethodChannelTzcash].
  static TzcashPlatform get instance => _instance;

  /// Platform-specific implementations should set this with their own
  /// platform-specific class that extends [TzcashPlatform] when
  /// they register themselves.
  static set instance(TzcashPlatform instance) {
    PlatformInterface.verifyToken(instance, _token);
    _instance = instance;
  }

  Future<String?> getPlatformVersion() {
    throw UnimplementedError('platformVersion() has not been implemented.');
  }

  Future<String?> callPayment(Map<String, dynamic> orderInfo) {
    throw UnimplementedError('callPayment() has not been implemented.');
  }

  // Add event channel handlers
  void onTZAppPay(Function(String) callback) {}
  void onMiniProgramPay(Function(String) callback) {}
}
