import 'package:flutter_test/flutter_test.dart';
import 'package:tzcash/tzcash.dart';
import 'package:tzcash/tzcash_platform_interface.dart';
import 'package:tzcash/tzcash_method_channel.dart';
import 'package:plugin_platform_interface/plugin_platform_interface.dart';

class MockTzcashPlatform
    with MockPlatformInterfaceMixin
    implements TzcashPlatform {

  @override
  Future<String?> getPlatformVersion() => Future.value('42');
}

void main() {
  final TzcashPlatform initialPlatform = TzcashPlatform.instance;

  test('$MethodChannelTzcash is the default instance', () {
    expect(initialPlatform, isInstanceOf<MethodChannelTzcash>());
  });

  test('getPlatformVersion', () async {
    Tzcash tzcashPlugin = Tzcash();
    MockTzcashPlatform fakePlatform = MockTzcashPlatform();
    TzcashPlatform.instance = fakePlatform;

    expect(await tzcashPlugin.getPlatformVersion(), '42');
  });
}
